/*** CONFIDENTIAL ***/
/* Copyright (C) 2011 2012 2013, Panasonic Corporation */
#include "avev3_machine.h"
#include "avev3.h"

static int gphy_type = AVEV3_PHY_MCRL;

extern int avev3_phy_reset_period;
extern int avev3_phy_reset_stability;

#ifdef AVEV3_ENABLE_POL_LINKCHK 
int avev3_poll_link = 0;   
#endif 

extern int avev3_util_mac_read(unsigned char *mac_buf);

#if defined(CONFIG_ARM)
extern void purge_cache(unsigned long start, unsigned long size, int flag);
#endif 

long    avev3_get_macaddr(char *macaddr)
{

  avev3_util_mac_read(macaddr);

  if( (*(unsigned long *)&macaddr[0] == 0xFFFFFFFF)
      && (*(unsigned short *)&macaddr[4] == 0xFFFF) ){
    return -1;
  }

  return 0;
}


inline void avev3_peaks_set_irq_lvl(int irq)
{
}

inline void avev3_peaks_enable_irq(int irq)
{
  enable_irq(irq);
}

inline void avev3_peaks_disable_irq(int irq)
{
  disable_irq(irq);
}

void avev3_peaks_clear_irq(int irq)
{
}

#ifndef AVEV3_MACHINE_BIGENDIAN
void avev3_endian_change(void *data)
{
  char *dataP = (char*)data;
  union ave_data_u{
    unsigned long hex;
    char str[4];
  } ave_data;
    
  ave_data.hex = *(unsigned long *)data;
  dataP[0] = ave_data.str[3];
  dataP[1] = ave_data.str[2];
  dataP[2] = ave_data.str[1];
  dataP[3] = ave_data.str[0];
}
#else
void avev3_endian_change(void *data)
{
}
#endif



#ifdef AVEV3_SELECT_BUILT_IN_PHY

unsigned long avev3_read_socreg( unsigned long addr )
{
    void __iomem *regadrP;
    unsigned long value;

    regadrP = ioremap( addr, 4 );
    if( regadrP == NULL ){
        printk(KERN_ERR "avev3: Could not ioremap device I/O.\n");
        return(0);  
    }
    value = readl( regadrP );
    iounmap( regadrP );

    return( value );
}

void avev3_phy_set_analog_param( struct net_device *dev )
{
    struct avev3_private *priv = netdev_priv(dev);
    unsigned long reg;

    reg = (unsigned long)avev3_mdio_read(dev, priv->phy_id, RTL8201FL_P0R31_PSR);
    reg &= 0xffffff00;
    reg |= RTL8201FL_REG_PAGE1;     
    priv->mii_if.mdio_write(dev, priv->phy_id, RTL8201FL_P0R31_PSR, reg);

    reg = (unsigned long)avev3_mdio_read(dev, priv->phy_id, RTL8201FL_P1R17_PARAM);
    reg |= (_BIT13 | _BIT12 | _BIT11);    
    priv->mii_if.mdio_write(dev, priv->phy_id, RTL8201FL_P1R17_PARAM, reg);

    reg = (unsigned long)avev3_mdio_read(dev, priv->phy_id, RTL8201FL_P1R18_PARAM);
    if( reg == RTL8201FL_P1R18_DEFAULT ){   
        reg = RTL8201FL_P1R18_MODIFY;       
    }
    priv->mii_if.mdio_write(dev, priv->phy_id, RTL8201FL_P1R18_PARAM, reg);

    reg = (unsigned long)avev3_mdio_read(dev, priv->phy_id, RTL8201FL_P1R21_PARAM);
    reg &= (~(_BIT12 | _BIT11 | _BIT10)); 

    if( AVEV3_READ_SOCREG( AVEV3_SOCREG_REVISION ) >= 0x00290103 ){
        reg |= (_BIT12 | _BIT11);         
    }
    priv->mii_if.mdio_write(dev, priv->phy_id, RTL8201FL_P1R21_PARAM, reg);

    reg = (unsigned long)avev3_mdio_read(dev, priv->phy_id, RTL8201FL_P0R31_PSR);
    reg &= 0xffffff00;
    reg |= RTL8201FL_REG_PAGE0;
    priv->mii_if.mdio_write(dev, priv->phy_id, RTL8201FL_P0R31_PSR, reg);

    return;
}
#endif 




#ifdef  AVEV3_AUTO_SC_CHECK
#define BANK_SELECT             14
#endif

void initialize_target(void)
{
  return;
}

#if 0 
void initialize_target(void)
{
  unsigned long reg;
#ifdef  AVEV3_AUTO_SC_CHECK
  unsigned int bank;
  unsigned short rev_reg;
  int sbc_handshake = 0;
#endif

  reg = EXTMD0;
  reg &= ~(EXTMD_MSK << EXTMD_AVEV3_SHIFT);
  reg |= (EXTMD_LOW << EXTMD_AVEV3_SHIFT);
  EXTMD0 = reg;


#ifndef AVEV3_TARGET_INIT_BY_BOOT
#ifdef  AVEV3_AUTO_SC_CHECK
  bank = inw( 0x01f00000 + BANK_SELECT );
  if ( (bank & 0xFF00) != 0x3300 ) {
    DBG_PRINT("No Support Card Detected.\n");
    sbc_handshake = 1;
  } else {
    outw( 3, 0x01f00000 + BANK_SELECT );
    rev_reg = inw( 0x01f00000 + 0x0A );
    printk("May be support card SMSC ether...\n");
    if ( (rev_reg & 0xf0) == 0x90 ) {
      printk("Supportcard ether(SMC91C11x)! (rev_reg = 0x%04x)\n", rev_reg);
      sbc_handshake = 0;
    } else {
      DBG_PRINT("Not SMC91C11x. Doesn't supportcard.\n");
      sbc_handshake = 1;
    }
  }
#endif

  DBG_PRINT("SBBASE%d = 0x%08x\n", (int)_AVEV3_CS,
        *((volatile unsigned int *)_AVEV3_SBBASE));
  *((volatile unsigned int *)_AVEV3_SBBASE) = ((0x80000001UL +
                           (CS_ADDR_INC * LAN_CS)) |
                          CS_MASK);
  DBG_PRINT("SBBASE%d = 0x%08x\n", (int)_AVEV3_CS,
        *((volatile unsigned int *)_AVEV3_SBBASE));
  DBG_PRINT("SBCTRL%d0 = 0x%08x\n", (int)_AVEV3_CS,
        *((volatile unsigned int *)_AVEV3_SBCTRL0));
  *((volatile unsigned int *)_AVEV3_SBCTRL0) = 0x11111000;
  DBG_PRINT("SBCTRL%d0 = 0x%08x\n", (int)_AVEV3_CS,
        *((volatile unsigned int *)_AVEV3_SBCTRL0));
  DBG_PRINT("SBCTRL%d1 = 0x%08x\n", (int)_AVEV3_CS,
        *((volatile unsigned int *)_AVEV3_SBCTRL1));
  *((volatile unsigned int *)_AVEV3_SBCTRL1) = 0x11010100;
  DBG_PRINT("SBCTRL%d1 = 0x%08x\n", (int)_AVEV3_CS,
        *((volatile unsigned int *)_AVEV3_SBCTRL1));
  DBG_PRINT("SBCTRL%d2 = 0x%08x\n", (int)_AVEV3_CS,
        *((volatile unsigned int *)_AVEV3_SBCTRL2));
#ifdef  AVEV3_AUTO_SC_CHECK
  if ( sbc_handshake != 0 ) {
    *((volatile unsigned int *)_AVEV3_SBCTRL2) = AVEV3_SBC_HANDSHAKE;
  } else {
    *((volatile unsigned int *)_AVEV3_SBCTRL2) = AVEV3_SBC_FIXWAIT_MAX;
  }
#else
#ifndef AVEV3_USE_SUPPORTCARD
  *((volatile unsigned int *)_AVEV3_SBCTRL2) = AVEV3_SBC_HANDSHAKE;
#else
  *((volatile unsigned int *)_AVEV3_SBCTRL2) = AVEV3_SBC_FIXWAIT_MAX;
#endif 
#endif
  DBG_PRINT("SBCTRL%d2 = 0x%08x\n", (int)_AVEV3_CS,
        *((volatile unsigned int *)_AVEV3_SBCTRL2));

#else
#endif 


#ifndef _AVEV3_TEST_ES
  reg = inl(_AVEV3_FPGA_BASE + 0xffffc);
  printk("Dummy SoC Ver=0x%04lx    DMAC Ver=0x%04lx\n",
         ((reg & 0x0000fffe) >> 1), reg >> 16);

  outl(0x00000000, _AVEV3_FPGA_BASE + 0xffffc);
#endif 

  return;
}
#endif 



int avev3_phy_init(struct net_device *dev)
{
  struct avev3_private *priv = netdev_priv(dev);
  unsigned long sid1, sid2; 
  unsigned long reg;

  int i;

#ifdef AVEV3_ENABLE_POL_LINKCHK 
  avev3_poll_link = 0;  
#endif 

#ifdef AVEV3_PHY_AUTODETECT 

  printk(KERN_DEBUG "avev3: phy_id = 0x%08x\n", priv->phy_id);
  printk(KERN_INFO "avev3: phy_id auto-detection start.\n");

  for ( i = 1; i < 0x20; i++ ) {
    sid1 = priv->mii_if.mdio_read(dev, i, MII_PHYSID1);
    sid2 = priv->mii_if.mdio_read(dev, i, MII_PHYSID2);

    if ( ((sid1 & 0xffff) == 0x0022) && ((sid2 & 0xfC00) == 0x1400) ) {
      printk("avev3: micrel: phy_id 0x%02x sid 0x%08lx\n",
              i, (sid1<<16 | sid2));
      priv->phy_id = i;
      priv->mii_if.phy_id = i;

      avev3_phy_reset_period = 1000;    
      avev3_phy_reset_stability = 100;  

      reg = priv->mii_if.mdio_read(dev, priv->phy_id, MII_MCRL_CTRL2);
      reg &= (~MCRL_POWERSAVE); 
#ifndef AVEV3_MICREL_AMDIX_ON
      if ( netif_msg_link(priv) ) {
        DBG_PRINT("Disable AutoMDI/MDIX\n");
      }
      reg |= MCRL_PAIRSWAP_D;   
#endif
      priv->mii_if.mdio_write(dev, priv->phy_id, MII_MCRL_CTRL2, reg);

      reg = priv->mii_if.mdio_read(dev, priv->phy_id, MII_ADVERTISE);
      reg |= MCRL_ADV_PAUSE;    
      priv->mii_if.mdio_write(dev, priv->phy_id, MII_ADVERTISE, reg);

      if( (sid2 & 0x03f0) != 0x0150 ){ 
        reg = (unsigned long)avev3_mdio_read(dev, priv->phy_id, MII_BMCR);

        if( (reg & BMCR_ANENABLE) != 0 ){
          avev3_mdio_read(dev, priv->phy_id, MII_MCRL_ICS);
          reg |= BMCR_ANRESTART;
          priv->mii_if.mdio_write(dev, priv->phy_id, MII_BMCR, (int)reg);
        }
      } 
      priv->mii_if.mdio_write(dev, priv->phy_id, MII_MCRL_ICS,
                              MCRL_CTRL_UP | MCRL_CTRL_DOWN);

      if( (sid2 & 0x03f0) == 0x0150 ){ 
        reg = (unsigned long)avev3_mdio_read(dev, priv->phy_id, MII_BMCR);

        if( (reg & BMCR_ANENABLE) != 0 ){
          avev3_mdio_read(dev, priv->phy_id, MII_MCRL_ICS);
          udelay(500);
          reg &= ~BMCR_ANENABLE;
          priv->mii_if.mdio_write(dev, priv->phy_id, MII_BMCR, (int)reg);
          udelay(500);
          reg |= BMCR_ANENABLE;
          priv->mii_if.mdio_write(dev, priv->phy_id, MII_BMCR, (int)reg);
        }
      } 
      gphy_type = AVEV3_PHY_MCRL;

      break;
    } else if ( ((sid1 & 0xffff) == 0x004d) && ((sid2 & 0xfC00) == 0xd000) ) {
      printk("avev3: atheros: phy_id 0x%02x sid 0x%08lx\n",
              i, (sid1<<16 | sid2));

      priv->phy_id = i;
      priv->mii_if.phy_id = i;

      avev3_phy_reset_period = 1000;    
      avev3_phy_reset_stability = 1000;  

      reg = priv->mii_if.mdio_read(dev, priv->phy_id, MII_ADVERTISE);
      reg |= MCRL_ADV_PAUSE;    
      priv->mii_if.mdio_write(dev, priv->phy_id, MII_ADVERTISE, reg);

      reg = (unsigned long)avev3_mdio_read(dev, priv->phy_id, MII_BMCR);

      if( (reg & BMCR_ANENABLE) != 0 ){
        avev3_mdio_read(dev, priv->phy_id, MII_ATHRS_ISR);
        reg |= BMCR_ANRESTART;
        priv->mii_if.mdio_write(dev, priv->phy_id, MII_BMCR, (int)reg);
      }
      priv->mii_if.mdio_write(dev, priv->phy_id, MII_ATHRS_ICR,
                              (ATHRS_INT_LKUP | ATHRS_INT_LKDN) );

      AVEV3_REG_WRITE(_AVEV3_SIGNAL_H, _AVEV3_SIGNAL);

      gphy_type = AVEV3_PHY_ATHRS;

      break;
    } else if ( ((sid1 & 0xffff) == 0x001C) && ((sid2 & 0xfC00) == 0xC800) ) {
      printk("avev3: realtek: phy_id 0x%02x sid 0x%08lx\n", i, (sid1<<16 | sid2));

      priv->phy_id = i;
      priv->mii_if.phy_id = i;

      avev3_phy_reset_period = 20*1000;      
      avev3_phy_reset_stability = 280*1000;  

      reg = priv->mii_if.mdio_read(dev, priv->phy_id, MII_ADVERTISE);
      reg |= ADVERTISE_PAUSE_CAP;    
      priv->mii_if.mdio_write(dev, priv->phy_id, MII_ADVERTISE, reg);

#if 1
      if ( (sid2 & 0x000f) != 0x0005 ) {   
        unsigned long reg2;

        printk("avev3: realtek: rtl8201f setting \n");

        avev3_phy_reset_stability = 160*1000;  

#ifdef AVEV3_SELECT_BUILT_IN_PHY

        avev3_phy_set_analog_param( dev );

#else 
        reg = (unsigned long)avev3_mdio_read(dev, priv->phy_id, RTL8201FL_P0R31_PSR);
        reg = RTL8201FL_REG_PAGE7;
        priv->mii_if.mdio_write(dev, priv->phy_id, RTL8201FL_P0R31_PSR, reg);

        reg = (unsigned long)avev3_mdio_read(dev, priv->phy_id, RTL8201FL_P7R24_SSCR);  
        reg |= RTL8201FL_SSC_DISABLE;
        priv->mii_if.mdio_write(dev, priv->phy_id, RTL8201FL_P7R24_SSCR, reg);

        reg = (unsigned long)avev3_mdio_read(dev, priv->phy_id, RTL8201FL_P0R31_PSR);
        reg = RTL8201FL_REG_PAGE0;
        priv->mii_if.mdio_write(dev, priv->phy_id, RTL8201FL_P0R31_PSR, reg);

#endif 

        reg = RTL8201FL_MMD_ADDR_DEV7;
        priv->mii_if.mdio_write(dev, priv->phy_id, RTL8201FL_P0R13_MACR, reg);

        reg = RTL8201FL_MMDD7_EEEAR;
        priv->mii_if.mdio_write(dev, priv->phy_id, RTL8201FL_P0R14_MAADR, reg);

        reg = RTL8201FL_MMD_DATA_DEV7;
        priv->mii_if.mdio_write(dev, priv->phy_id, RTL8201FL_P0R13_MACR, reg);

        reg2 = (unsigned long)avev3_mdio_read(dev, priv->phy_id, RTL8201FL_P0R14_MAADR);

        reg = RTL8201FL_MMD_ADDR_DEV7;
        priv->mii_if.mdio_write(dev, priv->phy_id, RTL8201FL_P0R13_MACR, reg);

        reg = RTL8201FL_MMDD7_EEEAR;
        priv->mii_if.mdio_write(dev, priv->phy_id, RTL8201FL_P0R14_MAADR, reg);

        reg = RTL8201FL_MMD_DATA_DEV7;
        priv->mii_if.mdio_write(dev, priv->phy_id, RTL8201FL_P0R13_MACR, reg);

        reg2 &= ~RTL8201FL_EEE_ENABLE;
        priv->mii_if.mdio_write(dev, priv->phy_id, RTL8201FL_P0R14_MAADR, reg2);
      }
#endif

      reg = (unsigned long)avev3_mdio_read(dev, priv->phy_id, MII_BMCR);

#ifdef AVEV3_SELECT_BUILT_IN_PHY
      {
        unsigned long reg2;
        reg2 = reg;
        reg2 |= BMCR_ANRESTART;
        priv->mii_if.mdio_write(dev, priv->phy_id, MII_BMCR, (int)reg2);

        if( (reg & BMCR_ANENABLE) == 0 ){    
          priv->mii_if.mdio_write(dev, priv->phy_id, MII_BMCR, (int)reg);
        }
      }

#else 
      if( (reg & BMCR_ANENABLE) != 0 ){
        reg |= BMCR_ANRESTART;
        priv->mii_if.mdio_write(dev, priv->phy_id, MII_BMCR, (int)reg);
      }

#endif 
      gphy_type = AVEV3_PHY_REALTEK;

#ifdef AVEV3_ENABLE_POL_LINKCHK 
      avev3_poll_link = 1; 
#endif 

      break;
    } else if ( ((sid1 & 0xffff) == 0x0007) && ((sid2 & 0xfC00) == 0xC000) ) {
      printk("avev3: smsc: phy_id 0x%02x sid 0x%08lx\n", i, (sid1<<16 | sid2));
      priv->phy_id = i;
      priv->mii_if.phy_id = i;

      avev3_phy_reset_period = 100; 
      avev3_phy_reset_stability = 1;    

      priv->mii_if.mdio_write(dev, priv->phy_id, MII_BMCR,
                  BMCR_FULLDPLX | BMCR_ANRESTART |
                  BMCR_ANENABLE | BMCR_SPEED100);

      priv->mii_if.mdio_write(dev, priv->phy_id, MII_SMSC_IMR,
                  SMSC_ANCOMP | SMSC_LINKDOWN);

      gphy_type = AVEV3_PHY_SMSC;

      break;
    }
  }
  if ( i > 0x1f ) {
    printk(KERN_ERR "avev3: couldn't proper PHY. phy_id is default.(0x%02x)\n",
       priv->phy_id);
    printk(KERN_ERR "avev3: avev3_panic(2)\n");
    avev3_panic(2);
    return -1;
  }

#else   
#ifdef SMSC_PHY

  gphy_type = AVEV3_PHY_SMSC;
  i = AVEV3_PHY_SMSC;

  printk(KERN_DEBUG "avev3: phy_id = 0x%08x\n", priv->phy_id);
  sid1 = priv->mii_if.mdio_read(dev, priv->phy_id, MII_PHYSID1);
  sid2 = priv->mii_if.mdio_read(dev, priv->phy_id, MII_PHYSID2);

  if ( ((sid1 & 0xffff) != 0x0007) || ((sid2 & 0xfC00) != 0xC000) ) {
    printk("avev3: phy(smsc phy 0x%02x) sid wrong.0x%08x\n",
       (unsigned char)priv->phy_id, (sid1<<16 | sid2));
  }

  priv->mii_if.mdio_write(dev, priv->phy_id, MII_BMCR,
              BMCR_FULLDPLX | BMCR_ANRESTART |
              BMCR_ANENABLE | BMCR_SPEED100);

  priv->mii_if.mdio_write(dev, priv->phy_id, MII_SMSC_IMR,
              SMSC_ANCOMP | SMSC_LINKDOWN);

#else   

  gphy_type = AVEV3_PHY_MCRL;
  i = AVEV3_PHY_MCRL;

  printk(KERN_DEBUG "avev3: phy_id = 0x%08x\n", priv->phy_id);
  sid1 = priv->mii_if.mdio_read(dev, priv->phy_id, MII_PHYSID1);
  sid2 = priv->mii_if.mdio_read(dev, priv->phy_id, MII_PHYSID2);

  if ( ((sid1 & 0xffff) != 0x0022) || ((sid2 & 0xfC00) != 0x1400) ) {
    printk("avev3: phy(micrel phy 0x%02x) sid wrong.0x%08x\n",
       (unsigned char)priv->phy_id, (sid1<<16 | sid2));
  }

  reg = priv->mii_if.mdio_read(dev, priv->phy_id, MII_MCRL_CTRL2);
  reg &= (~MCRL_POWERSAVE); 
#ifndef AVEV3_MICREL_AMDIX_ON
  reg |= MCRL_PAIRSWAP_D;   
#endif
  priv->mii_if.mdio_write(dev, priv->phy_id, MII_MCRL_CTRL2, reg);

  priv->mii_if.mdio_write(dev, priv->phy_id, MII_BMCR,
              BMCR_ANRESTART |
              BMCR_ANENABLE | BMCR_SPEED100);

  priv->mii_if.mdio_write(dev, priv->phy_id, MII_MCRL_ICS,
              MCRL_CTRL_UP | MCRL_CTRL_DOWN);

#endif
#endif

  return i;
}

int avev3_phy_intr_chkstate_negate(struct net_device *dev)
{
  struct avev3_private *priv = netdev_priv(dev);
  unsigned long reg;

  if ( gphy_type == AVEV3_PHY_MCRL ) {
    reg = priv->mii_if.mdio_read(dev, priv->phy_id, MII_MCRL_ICS);
    if ( netif_msg_link(priv) ) {
      DBG_PRINT("avev3: PHY INTR 0x%02x\n", (char)(reg & 0xff));
    }

    if ( (reg & MCRL_STS_UP) != 0x0 ) {
      return _AVEV3_LS_UP;
    } else if ( (reg & MCRL_STS_DOWN) != 0x00 ) {
      return _AVEV3_LS_DOWN;
    } else {
      return _AVEV3_LS_NOTHING;
    }


  } else if ( gphy_type == AVEV3_PHY_ATHRS ) {
    reg = priv->mii_if.mdio_read(dev, priv->phy_id, MII_ATHRS_ISR);
    if ( netif_msg_link(priv) ) {
      DBG_PRINT("avev3: PHY INTR 0x%02x\n", (char)(reg & 0xff));
    }

    if ( (reg & ATHRS_INT_LKUP) != 0x0 ) {
      return _AVEV3_LS_UP;
    } else if ( (reg & ATHRS_INT_LKDN) != 0x00 ) {
      return _AVEV3_LS_DOWN;
    } else {
      return _AVEV3_LS_NOTHING;
    }

  } else {  
    reg = priv->mii_if.mdio_read(dev, priv->phy_id, MII_SMSC_ISFR);
    if ( netif_msg_link(priv) ) {
      DBG_PRINT(KERN_DEBUG "avev3: PHY INTR 0x%04x\n", (unsigned short)reg);
    }

    if ( (reg & SMSC_ANCOMP) != 0x0 ) {
      return _AVEV3_LS_UP;
    } else if ( (reg & SMSC_LINKDOWN) != 0x0 ) {
      return _AVEV3_LS_DOWN;
    } else {
      return _AVEV3_LS_NOTHING;
    }

  }
}


inline void avev3_purge_cache(unsigned long start, unsigned long size, int flag)
{
#if defined(CONFIG_ARM)
  purge_cache (virt_to_phys((void*)start), size, flag);
#else  
  purge_cache (start, size, flag);
#endif  
}

int avev3_panic(int panic_param)
{
  printk("avev3: kernel panic!\n");
  return 0; 
}
